/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package zold.ihm.ipriproto;


import proc.rss.RSSSaver;
import proc.rss.RSSLemmatizer;
import data.structures.rss.RSSFeed;
import data.structures.rss.RSSFeedInfo;
import data.base.connectors.RSSFeedDatabase;
import data.base.Database;
import zold.data.base.connectors._StatisticsDatabase;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import zold.proc.parsing._Parser;
import zold.proc.tagging._RessourceLemmatizer;
//import zold.data.structures.thema._ThemaGraph;
import zold.proc.tagging._ThemaLemmatizer;
import java.util.Iterator;
import org.xml.sax.SAXException;
/**
 * The application's main frame.
 */
public class _IHMTest1View extends FrameView {

    public _IHMTest1View(SingleFrameApplication app) {
        super(app);

        initComponents();

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);

    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = _IHMTest1App.getApplication().getMainFrame();
            aboutBox = new _IHMTest1AboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        _IHMTest1App.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel_Launcher = new javax.swing.JPanel();
        jButtonStartStop = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea_LogWnd = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jPanel_RSSFeedTest = new javax.swing.JPanel();
        urlTextField = new javax.swing.JTextField();
        showFeedBtn = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        feedTextArea = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jButtonLemmatizeAll = new javax.swing.JButton();
        jButtonLemmatizeUnLemmatized = new javax.swing.JButton();
        jButtonLemmatizeBetweenDates = new javax.swing.JButton();
        jTextFieldStartDate = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldEndDate = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaLemmatizeLog = new javax.swing.JTextArea();
        jPanel2 = new javax.swing.JPanel();
        jFileChooser1 = new javax.swing.JFileChooser();
        jButton4 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jButton7 = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jButton8 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jButton6 = new javax.swing.JButton();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();

        mainPanel.setName("mainPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(zold.ihm.ipriproto._IHMTest1App.class).getContext().getActionMap(_IHMTest1View.class, this);
        jButton1.setAction(actionMap.get("quit")); // NOI18N
        jButton1.setName("jButton1"); // NOI18N

        jButton2.setAction(actionMap.get("showDlg")); // NOI18N
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(zold.ihm.ipriproto._IHMTest1App.class).getContext().getResourceMap(_IHMTest1View.class);
        jButton2.setText(resourceMap.getString("ShowDlg1Btn.text")); // NOI18N
        jButton2.setName("ShowDlg1Btn"); // NOI18N

        jTabbedPane1.setName("thesaurus"); // NOI18N

        jPanel_Launcher.setName("jPanel_Launcher"); // NOI18N

        jButtonStartStop.setAction(actionMap.get("StartStopTimer")); // NOI18N
        jButtonStartStop.setText(resourceMap.getString("jButtonStartStop.text")); // NOI18N
        jButtonStartStop.setName("jButtonStartStop"); // NOI18N

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        jTextArea_LogWnd.setColumns(20);
        jTextArea_LogWnd.setRows(5);
        jTextArea_LogWnd.setName("jTextArea_LogWnd"); // NOI18N
        jScrollPane2.setViewportView(jTextArea_LogWnd);

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        javax.swing.GroupLayout jPanel_LauncherLayout = new javax.swing.GroupLayout(jPanel_Launcher);
        jPanel_Launcher.setLayout(jPanel_LauncherLayout);
        jPanel_LauncherLayout.setHorizontalGroup(
            jPanel_LauncherLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_LauncherLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_LauncherLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 705, Short.MAX_VALUE)
                    .addComponent(jButtonStartStop, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel_LauncherLayout.setVerticalGroup(
            jPanel_LauncherLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_LauncherLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonStartStop, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 292, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel_Launcher.TabConstraints.tabTitle"), jPanel_Launcher); // NOI18N

        jPanel_RSSFeedTest.setName("jPanel_RSSFeedTest"); // NOI18N

        urlTextField.setText(resourceMap.getString("jRSSFeedURLTextField.text")); // NOI18N
        urlTextField.setName("jRSSFeedURLTextField"); // NOI18N

        showFeedBtn.setAction(actionMap.get("ShowRSSFeed")); // NOI18N
        showFeedBtn.setText(resourceMap.getString("jShowRSSButton.text")); // NOI18N
        showFeedBtn.setName("jShowRSSButton"); // NOI18N
        showFeedBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showFeedBtnActionPerformed(evt);
            }
        });

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        feedTextArea.setColumns(20);
        feedTextArea.setRows(5);
        feedTextArea.setName("jRSSOutPutTextArea1"); // NOI18N
        jScrollPane1.setViewportView(feedTextArea);

        javax.swing.GroupLayout jPanel_RSSFeedTestLayout = new javax.swing.GroupLayout(jPanel_RSSFeedTest);
        jPanel_RSSFeedTest.setLayout(jPanel_RSSFeedTestLayout);
        jPanel_RSSFeedTestLayout.setHorizontalGroup(
            jPanel_RSSFeedTestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_RSSFeedTestLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_RSSFeedTestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 705, Short.MAX_VALUE)
                    .addGroup(jPanel_RSSFeedTestLayout.createSequentialGroup()
                        .addComponent(urlTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 372, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(showFeedBtn)))
                .addContainerGap())
        );
        jPanel_RSSFeedTestLayout.setVerticalGroup(
            jPanel_RSSFeedTestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_RSSFeedTestLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_RSSFeedTestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(urlTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(showFeedBtn, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 326, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel_RSSFeedTest.TabConstraints.tabTitle"), jPanel_RSSFeedTest); // NOI18N

        jPanel1.setName("jPanel1"); // NOI18N

        jButtonLemmatizeAll.setAction(actionMap.get("RSSLemmatizedAll")); // NOI18N
        jButtonLemmatizeAll.setName("jButtonLemmatizeAll"); // NOI18N
        jButtonLemmatizeAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLemmatizeAllActionPerformed(evt);
            }
        });

        jButtonLemmatizeUnLemmatized.setText(resourceMap.getString("jButtonLemmatizeUnLemmatized.text")); // NOI18N
        jButtonLemmatizeUnLemmatized.setName("jButtonLemmatizeUnLemmatized"); // NOI18N

        jButtonLemmatizeBetweenDates.setText(resourceMap.getString("jButtonLemmatizeBetweenDates.text")); // NOI18N
        jButtonLemmatizeBetweenDates.setName("jButtonLemmatizeBetweenDates"); // NOI18N

        jTextFieldStartDate.setText(resourceMap.getString("jTextFieldStartDate.text")); // NOI18N
        jTextFieldStartDate.setName("jTextFieldStartDate"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        jTextFieldEndDate.setText(resourceMap.getString("jTextFieldEndDate.text")); // NOI18N
        jTextFieldEndDate.setName("jTextFieldEndDate"); // NOI18N

        jScrollPane3.setName("jScrollPane3"); // NOI18N

        jTextAreaLemmatizeLog.setColumns(20);
        jTextAreaLemmatizeLog.setRows(5);
        jTextAreaLemmatizeLog.setName("jTextAreaLemmatizeLog"); // NOI18N
        jScrollPane3.setViewportView(jTextAreaLemmatizeLog);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(35, 35, 35)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 528, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jButtonLemmatizeBetweenDates, javax.swing.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jButtonLemmatizeAll, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jButtonLemmatizeUnLemmatized, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 197, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(37, 37, 37)
                        .addComponent(jLabel2)
                        .addGap(18, 18, 18)
                        .addComponent(jTextFieldStartDate, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldEndDate, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(190, 190, 190))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(jButtonLemmatizeAll)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonLemmatizeUnLemmatized)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonLemmatizeBetweenDates)
                    .addComponent(jTextFieldStartDate, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jTextFieldEndDate, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addGap(29, 29, 29)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 232, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(31, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle"), jPanel1); // NOI18N

        jPanel2.setName("jPanel2"); // NOI18N

        jFileChooser1.setName("jFileChooser1"); // NOI18N
        jFileChooser1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jFileChooser1ActionPerformed(evt);
            }
        });

        jButton4.setAction(actionMap.get("Thema_lemmatize")); // NOI18N
        jButton4.setText(resourceMap.getString("jButton4.text")); // NOI18N
        jButton4.setName("jButton4"); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jFileChooser1, javax.swing.GroupLayout.PREFERRED_SIZE, 616, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButton4)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jFileChooser1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 389, Short.MAX_VALUE)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jButton4)
                .addContainerGap())
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel2.TabConstraints.tabTitle"), jPanel2); // NOI18N

        jPanel3.setName("jPanel3"); // NOI18N

        jButton3.setAction(actionMap.get("PublicationStatistics")); // NOI18N
        jButton3.setText(resourceMap.getString("jButton3.text")); // NOI18N
        jButton3.setName("jButton3"); // NOI18N

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox1.setAction(actionMap.get("selectFeed")); // NOI18N
        jComboBox1.setName("jComboBox1"); // NOI18N

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(191, 191, 191)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton3))
                .addContainerGap(365, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(37, 37, 37)
                .addComponent(jButton3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(298, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel3.TabConstraints.tabTitle"), jPanel3); // NOI18N

        jPanel5.setName("jPanel5"); // NOI18N

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        jPanel6.setBackground(resourceMap.getColor("jPanel6.background")); // NOI18N
        jPanel6.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel6.setName("jPanel6"); // NOI18N

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jButton7.setAction(actionMap.get("Thema_identification")); // NOI18N
        jButton7.setText(resourceMap.getString("jButton7.text")); // NOI18N
        jButton7.setName("jButton7"); // NOI18N

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        jButton8.setAction(actionMap.get("recup_ontologie")); // NOI18N
        jButton8.setText(resourceMap.getString("jButton8.text")); // NOI18N
        jButton8.setName("jButton8"); // NOI18N

        jButton5.setAction(actionMap.get("showGraph")); // NOI18N
        jButton5.setText(resourceMap.getString("jButton5.text")); // NOI18N
        jButton5.setName("jButton5"); // NOI18N

        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N

        jLabel8.setText(resourceMap.getString("jLabel8.text")); // NOI18N
        jLabel8.setName("jLabel8"); // NOI18N

        jButton6.setAction(actionMap.get("getRessourceDesc")); // NOI18N
        jButton6.setText(resourceMap.getString("jButton6.text")); // NOI18N
        jButton6.setName("jButton6"); // NOI18N

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap(152, Short.MAX_VALUE)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(jLabel8)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButton6))
                    .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                            .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jLabel6)
                                .addComponent(jLabel5))
                            .addGap(52, 52, 52)
                            .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jButton8)
                                .addComponent(jButton7)))
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                            .addComponent(jLabel7)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton5))))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jButton7)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jButton8)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jButton5)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(jButton6))
                .addContainerGap(28, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addContainerGap(196, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel4)
                .addGap(18, 18, 18)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(190, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel5.TabConstraints.tabTitle"), jPanel5); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 730, Short.MAX_VALUE)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addComponent(jButton2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 417, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 68, Short.MAX_VALUE)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButton2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButton1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 750, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 730, Short.MAX_VALUE)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel))
                .addGap(3, 3, 3))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    private void jFileChooser1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jFileChooser1ActionPerformed

        File file = jFileChooser1.getSelectedFile();
        /*try {
            ThesaurusLoad(file);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(_IHMTest1View.class.getName()).log(Level.SEVERE, null, ex);
        }*/
}//GEN-LAST:event_jFileChooser1ActionPerformed

    private void jButtonLemmatizeAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLemmatizeAllActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jButtonLemmatizeAllActionPerformed

    private void showFeedBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showFeedBtnActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_showFeedBtnActionPerformed

    @Action
    public void showDlg() {
        if (leDlg == null) {
            leDlg = new _NewOkCancelDialog(_IHMTest1App.getApplication().getMainFrame(),true);
        }
        //IHMTest1App.getApplication().show(leDlg);
        leDlg.setVisible(true);
    }

    @Action
    public void ShowRSSFeed() {
        RSSFeed theFeed = new RSSFeed();
        theFeed.InitRSS(urlTextField.getText());
        feedTextArea.setText(theFeed.GetRSSFeed());
        
    }

    @Action
    public void StartStopTimer() {
        if (timerOn) {
            jButtonStartStop.setText("Start");
            timerOn = false;
            theDB.disconnect();
            monTimer.stop();   
        }
        else {
            jButtonStartStop.setText("Stop");
            timerOn = true;
            monTimer.start(); 
            if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
               jButtonStartStop.setText("Start");
               timerOn = false;
               monTimer.stop();
               return;
            }
            //run once at the beginning
            RSSSaver theRSS_Saver = new RSSSaver(theDB);
            //theRSS_Saver.ReadFeeds();
                    /*
             jTextArea_LogWnd.append(String.valueOf(theV.size()));
            jTextArea_LogWnd.append("\n");
             */
        }
    }

    @Action
    public void RSSLemmatizedAll() {
        if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
            RSSLemmatizer theRSS_lemmatize = new RSSLemmatizer(theDB);
            //theRSS_lemmatize.reLemmatizedAll();
        }
    }

    /**
     * Method executed at each timer tick. Updates the RSS feeds
     */
    private ActionListener taskPerformer = new ActionListener() {
	      public void actionPerformed(ActionEvent evt) {
	    	  theDate = new java.util.Date();
                  jTextArea_LogWnd.append(theDate.toString());
                  jTextArea_LogWnd.append("\n");
                  RSSSaver theRSS_Saver = new RSSSaver(theDB);
                  //theRSS_Saver.ReadFeeds();
 	    	  
	      }
	};

    /*public void ThesaurusLoad(File file) throws ParserConfigurationException
    {
        if(file != null){
            _Parser theParser = new _Parser(theDB);
            if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
            }
            else{
                try {
                    theParser.selectFile(file);
                } catch (SAXException ex) {
                    Logger.getLogger(_IHMTest1View.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(_IHMTest1View.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        else{
            System.out.println("No file to load, please select a file");
        }
    }*/

    /*@Action
    public void PublicationStatistics() {
        if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
            _StatisticsDatabase theStats = new _StatisticsDatabase(theDB);
            theStats.retrieve();
        }
    }*/

    /*@Action
    public void selectFeed() {
       if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
            RSSFeedDatabase mySource = new RSSFeedDatabase(theDB);
            Vector<RSSFeedInfo> feeds = mySource.GetRSSFeedList();
            for(Iterator iter = feeds.iterator();iter.hasNext();)
            {
                
            }
        }
    }*/

    /*@Action
    public void Thema_lemmatize() {
        if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
            _ThemaLemmatizer themaLemma = new _ThemaLemmatizer(theDB);
            themaLemma.lemmatizeThema();
        }
    }*/

    /*@Action
    public void showGraph() {
        if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
//            Thema_graph tg = new Thema_graph(theDB);
            _ThemaGraph tg = new _ThemaGraph(theDB);
            tg.display();
        }
    }*/

    @Action
    public void Thema_identification() {
        /*if (theDB.Connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
        ThemaIdentifier ti = new ThemaIdentifier(theDB);
        ti.process();
        }*/
    }

    @Action
    public void recup_ontologie() {
    /*if (theDB.Connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
        OntologyLinker ol = new OntologyLinker(theDB);
        ol.process();
        }*/
    }

    @Action
    public void getRessourceDesc() {
        if (theDB.connect()!= Database.DB_OK){
               javax.swing.JOptionPane.showMessageDialog(null,"Database connection error");
        }else{
//        DBPediaDatabase db = new DBPediaDatabase(theDB);
//        db.updateAllDesc();
            _RessourceLemmatizer rl = new _RessourceLemmatizer(theDB);
            rl.lemmatizeRessources();
        }
    }

    private int LAPSE_TEMPS=1000000;
    private boolean timerOn = false;
    private Timer monTimer = new Timer(LAPSE_TEMPS, taskPerformer);
    private java.util.Date theDate;
    private Database theDB = new Database();
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea feedTextArea;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JButton jButtonLemmatizeAll;
    private javax.swing.JButton jButtonLemmatizeBetweenDates;
    private javax.swing.JButton jButtonLemmatizeUnLemmatized;
    private javax.swing.JButton jButtonStartStop;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JFileChooser jFileChooser1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel_Launcher;
    private javax.swing.JPanel jPanel_RSSFeedTest;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextAreaLemmatizeLog;
    private javax.swing.JTextArea jTextArea_LogWnd;
    private javax.swing.JTextField jTextFieldEndDate;
    private javax.swing.JTextField jTextFieldStartDate;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JButton showFeedBtn;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JTextField urlTextField;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
    private _NewOkCancelDialog leDlg;
}
